<?php

namespace App\Models\Company;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Location extends Model 
{

    protected $table = 'locations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function stock()
    {
        return $this->hasMany('App\Models\Stock\Stock', 'location_id');
    }

    public function parent()
    {
        return $this->belongsTo('App\Models\Company\Location', 'parent_id');
    }

    public function children()
    {
        return $this->hasMany('App\Models\Company\Location', 'parent_id');
    }

    public function positions()
    {
        return $this->hasMany('App\Models\HR\Position', 'location_id');
    }

}